﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Linq.Expressions;

namespace Chapter_16
{
    delegate bool NameMatch(string name);
    delegate bool TypeMatch<T>(T name);

    class Program
    {
        static void Main(string[] args)
        {
            // podstawowe wyrażenia lambda
            Func<string, bool> basic = lastName => lastName == "Mayo";
            Func<string, bool> verboseBasic = (string lastName) => { return lastName == "Mayo"; };

            // użycie wyrażenia lambda

            List<string> lastNames = new List<string> { "Einstein", "Gore", "Mayo" };

            var famousPeople = lastNames.FindAll(lastName => lastName != "Mayo");
            famousPeople.ForEach(lastName => Console.WriteLine(lastName));

            lastNames.
                FindAll(lastName => lastName != "Mayo").
                ForEach(lastName => Console.WriteLine(lastName));

            lastNames.ForEach(lastName =>
            {
                Console.Write("Nazwisko: ");
                if (lastName != "Mayo")
                {
                    Console.WriteLine(lastName); 
                }
                else
                {
                    Console.WriteLine("Kto?");
                }
            });

            // delegacje i wyrażenia lambda

            NameMatch nameMatch = lastName => lastName == "Mayo";
            TypeMatch<string> typeMatch = lastName => lastName == "Mayo";

            var match1 = GetMatchNormal(lastNames, nameMatch);
            var match2 = GetMatch<string>(lastNames, typeMatch);

            // delegacje Func<>
            Func<string, bool> matchFunc = lastName => lastName == "Mayo";
            bool matched = matchFunc("Beethoven");

            int matchCount = lastNames.Count(matchFunc);

            // bez parametrów
            Func<string> noParamLambda = () => "Jestem bezparametrowym wyrażeniem lambda";
            Console.WriteLine(noParamLambda());

            // wiele parametrów
            Func<string, int, string> encryptAlgorithm =
                (source, shift) =>
                {
                    char[] result = new char[source.Length];

                    for (int i = 0; i < source.Length; i++)
                    {
                        result[i] = (char)(source[i] + shift);
                    }

                    return new string(result);
                };

            string plainText = "HAL";
            int privateKey = 1;

            string cryptText = EncryptString(plainText, privateKey, encryptAlgorithm);
            
            cryptText = EncryptString(
                plainText, 
                privateKey,
                (source, shift) =>
                {
                    char[] result = new char[source.Length];

                    for (int i = 0; i < source.Length; i++)
                    {
                        result[i] = (char)(source[i] + shift);
                    }

                    return new string(result);
                });

            Console.WriteLine("Zaszyfrowany tekst: " + cryptText);

            matchCount = lastNames.Count(lastName => lastName == "Mayo");

            // drzewo wyrażeń

            Expression<Func<string, bool>> matchExpr = lastName => lastName == "Mayo";
            Expression<NameMatch> matchExpr2 = lastName => lastName == "Mayo";

            Console.WriteLine("Pole Type: " + matchExpr.Type);
            Console.WriteLine("Pole NodeType: " + matchExpr.NodeType);
            foreach (var parameter in matchExpr.Parameters)
            {
                Console.WriteLine("Pole Parameters: " + parameter);
            }
            Console.WriteLine("Pole Body: " + matchExpr.Body);

            Console.WriteLine(matchExpr);

            // analiza pola Body dla drzewa wyrażeń

            BinaryExpression body = matchExpr.Body as BinaryExpression;
            Console.WriteLine(
                "Elementy pola Body:\n\tLeft: {0}\n\tRight: {1}\n\tNode Type: {2}",
                body.Left, body.Right, body.NodeType);

            // dynamiczne tworzenie drzewa wyrażeń

            ParameterExpression paramExpr = Expression.Parameter(typeof(string), "lastName");
            ConstantExpression constExpr = Expression.Constant("Mayo", typeof(string));
            
            Expression<Func<string, bool>> dynamicExpressionTree =
                Expression.Lambda<Func<string, bool>>(
                    Expression.MakeBinary(
                        ExpressionType.Equal,
                        paramExpr,
                        constExpr),
                    new List<ParameterExpression> {paramExpr});

            Func<string, bool> dynamicLambda = dynamicExpressionTree.Compile();

            Console.WriteLine("dynamicLambda(\"Mayo\"): " + dynamicLambda("Mayo")); 

            Console.ReadKey();
        }

        private static string EncryptString(string plainText, int privateKey, Func<string, int, string> encryptAlgorithm)
        {
            return encryptAlgorithm(plainText, privateKey);
        }

        private static object GetMatchNormal(List<string> lastNames, NameMatch predicate)
        {
            List<string> matches = new List<string>();

            foreach (var name in lastNames)
            {
                if (predicate(name))
                {
                    matches.Add(name);
                }
            }

            return matches;
        }

        private static object GetMatch<TMatch>(List<TMatch> lastNames, TypeMatch<TMatch> predicate)
        {
            List<TMatch> matches = new List<TMatch>();

            foreach (var name in lastNames)
            {
                if (predicate(name))
                {
                    matches.Add(name);
                }
            }

            return matches;
        }

    }
}
